package gov.va.med.mhv.journal.web.util;

import gov.va.med.mhv.journal.dto.ActivityDetailDTO;

import java.io.Serializable;

public class ActivityTypeDecorator implements Serializable {

	private static final long serialVersionUID = -5681978817807725907L;

	public static String getDescription(ActivityDetailDTO activityType) {
		String description = "";
		
		if (null != activityType.getDistanceDuration() && activityType.getDistanceDuration().longValue() > 0) {
			description = description + activityType.getDistanceDuration() + " ";
		}
		
		if (null != activityType.getMeasure()) {
			description = getMeasureDescription(activityType) + " ";
		}
		
		if (null != activityType.getSetCount() && activityType.getSetCount().longValue() > 0) {
			description = description + activityType.getSetCount() + " ";
		}
		
		if (null != activityType.getRepCount() && activityType.getRepCount().longValue() > 0) {
			description = description + activityType.getRepCount() + " ";
		}
		
		if (null != activityType.getDescription()) {
			description = description + activityType.getDescription() + " ";
		}

		return description;
	}

	public static String getIntensity(ActivityDetailDTO activityType) {
		return (null != activityType.getIntensity())? "(" + activityType.getIntensity() + ")" : "";
	}
	
	public static String getTimeOfDay(ActivityDetailDTO activityType) {
		return (null != activityType.getTimeOfDay())? "(" + activityType.getTimeOfDay() + ")" : "";
	}

	public Long getActivityDetailId(ActivityDetailDTO activityType) {
		return activityType.getActivityDetailId();
	}

	private static String getMeasureDescription(ActivityDetailDTO activityType) {
		String measure = activityType.getMeasure();
		return measure == null ? "" : (String) ActivityTypeDetailMap.getMeasure().get(measure);
	}

	public static String getInstensityDescription(ActivityDetailDTO activityType) {
		if (activityType.getIntensity() != null ) {
			return activityType.getIntensity();
		}
		return activityType.getIntensity();
	}
}
